% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_engine.R
\name{train_scout_brain}
\alias{train_scout_brain}
\title{Train a similarity-based scouting model}
\usage{
train_scout_brain(df)
}
\arguments{
\item{df}{A cleaned data frame containing player information.}
}
\value{
A list containing:
\describe{
  \item{data}{A numeric matrix of standardized player features.}
  \item{players}{Character vector of player names.}
}
}
\description{
This function prepares numeric player features for similarity-based
scouting analysis.
}
\details{
The returned object is intended to be used as input for
\code{get_similar_players()}.
}
\examples{
df <- data.frame(
  name = c("Player A", "Player B"),
  age = c(21, 23),
  market_value_est = c(500, 750),
  club = c("Club A", "Club B"),
  league_country = c("Indonesia", "Indonesia"),
  stringsAsFactors = FALSE
)

model <- train_scout_brain(df)

}
