% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_engine.R
\name{get_similar_players}
\alias{get_similar_players}
\title{Retrieve similar players based on cosine similarity}
\usage{
get_similar_players(model, player_name, top_n = 5)
}
\arguments{
\item{model}{A trained scouting model returned by
\code{train_scout_brain()}.}

\item{player_name}{Character string specifying the reference player.}

\item{top_n}{Integer indicating the number of similar players to return.}
}
\value{
A data frame with similarity scores for the most similar players.
}
\description{
Retrieve similar players based on cosine similarity
}
\details{
Similarity is computed using cosine similarity on standardized
numeric features. The reference player is excluded from the results.
}
\examples{
df <- data.frame(
  name = c("Player A", "Player B", "Player C"),
  age = c(21, 23, 22),
  market_value_est = c(500, 750, 600),
  club = c("Club A", "Club B", "Club C"),
  league_country = c("Indonesia", "Indonesia", "Indonesia"),
  stringsAsFactors = FALSE
)

model <- train_scout_brain(df)
get_similar_players(model, "Player A", top_n = 2)

}
