% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_muni_id.R
\name{read_muni_id}
\alias{read_muni_id}
\title{Read municipalities id's and names}
\usage{
read_muni_id(id_types = c("muni", "edu", "tax"), include_names = FALSE)
}
\arguments{
\item{id_types}{A character vector of length between 1 and 3, containing at least
one (or two, or all of) of the possible values. id's (and possibly names) of
municipalities are kept for the selected sources:
\itemize{
\item \code{"muni"} is for CBS id's and (cleaned) names.
\item \code{"edu"} is for Ministry of Education municipal symbol ("Semel Reshut" in Hebrew)
\item \code{"tax"} is for Israel Tax Authority municipal id (also known as a "H.P. number")
}}

\item{include_names}{A logical vector of length 1, denoting if the names of
municipalities (for each of the \code{id_types} chosen) should be included. Be aware
that some municipal names might differ between different agencies.}
}
\value{
A tibble, where every row is a municipality and the columns include id's
(and possibly names) of the municipalities from the chosen agencies.
}
\description{
Israeli municipalities have different id's and sometimes even different names
across different government organizations. This function allows you to read
different municipality id's and names , so interchanging between the different
specifications would be easier.
}
\examples{
read_muni_id() |>
  dplyr::glimpse()

read_muni_id(id_types = c("muni", "edu"), include_names = TRUE) |>
  dplyr::glimpse()
}
