% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vtk.R
\name{io-vtk-streamlines}
\alias{io-vtk-streamlines}
\alias{io_read_vtk_streamlines}
\alias{io_write_vtk_streamlines}
\title{Read or write streamline data in \code{'VTK'} format}
\usage{
io_read_vtk_streamlines(file)

io_write_vtk_streamlines(x, con, binary = TRUE)
}
\arguments{
\item{file, con}{file path to the \code{'VTK'} file, the format will be
inferred from the file extension (with default \code{'.vtk'})}

\item{x}{An \code{\link{imaging-streamlines}} object}

\item{binary}{for legacy \code{'.vtk'} file only, whether to store the
data as binary file or 'ASCII' plain text; default is true (binary).}
}
\value{
\code{io_read_vtk_streamlines} returns an
\code{\link{imaging-streamlines}} object, while
\code{io_write_vtk_streamlines} writes the data to file
}
\description{
This reader uses 'Python' \code{'vtk'} package, supports \code{'.vtk'},
\code{'.vtp'}, \code{'.pvtp'}, \code{'.vtpb'} formats.
}
\examples{

# This example shows how to convert tck to vtk

# run `ieegio_sample_data("streamlines/CNVII_R.tck")` to
# download sample data

if( ieegio_sample_data("streamlines/CNVII_R.tck", test = TRUE) ) {

  path <- ieegio_sample_data("streamlines/CNVII_R.tck")

  streamlines <- as_ieegio_streamlines(path)

  # write to vtk
  tfile <- tempfile(fileext = ".vtk")
  io_write_vtk_streamlines(streamlines, con = tfile)

  # read
  vtk_streamlines <- io_read_vtk_streamlines(tfile)

  # compare
  plot(streamlines)
  plot(vtk_streamlines)

  # 0 0
  range(streamlines[[1]]$coords - vtk_streamlines[[1]]$coords)

}


}
