% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{parse_ibge_value}
\alias{parse_ibge_value}
\title{Parse IBGE value column}
\usage{
parse_ibge_value(x)
}
\arguments{
\item{x}{A character or numeric vector of IBGE values.}
}
\value{
A numeric vector where:
\itemize{
\item \code{"-"} becomes \code{0}
\item \code{".."}, \code{"..."} and \code{"X"} become \code{NA_real_}
\item All other values are converted with \code{\link[=as.numeric]{as.numeric()}}
}
}
\description{
Converts the character \code{value} column returned by \code{\link[=ibge_variables]{ibge_variables()}} to
numeric, handling IBGE special value conventions.
}
\details{
According to IBGE's tabular presentation standards, the value column may
contain special character codes instead of numbers:\tabular{ll}{
   Code \tab Meaning \cr
   \code{-} \tab Numeric value equal to zero (not from rounding) \cr
   \code{..} \tab Not applicable \cr
   \code{...} \tab Data not available \cr
   \code{X} \tab Suppressed to avoid identifying individual respondents \cr
}
}
\examples{
parse_ibge_value(c("1.5", "10", "-", "..", "...", "X", NA))
#> [1] 1.5  10.0  0.0   NA    NA    NA    NA

\dontrun{
# Typical usage after ibge_variables()
library(dplyr)

ibge_variables(7060, localities = "BR") |>
  mutate(value = parse_ibge_value(value))
}

}
