% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3_plot.R
\name{plot.FRTCI.test}
\alias{plot.FRTCI.test}
\title{plot.FRTCI.test}
\usage{
\method{plot}{FRTCI.test}(
  x,
  true.tau = NULL,
  xlab = expression(tau),
  ylab = "p-value",
  true.tau.col = "red",
  plot.envelope = TRUE,
  ci.line.col = "blue",
  ...
)
}
\arguments{
\item{x}{An object of class \code{FRTCI.test}}

\item{true.tau}{The true value of tau, if known. Default is NULL.}

\item{xlab}{X-axis label. Default is tau.}

\item{ylab}{Y-axis label. Default is "p-value".}

\item{true.tau.col}{Color to plot true tau value, if provided. Default is red.}

\item{plot.envelope}{Plot envelope around tested values of tau. Default is TRUE.}

\item{ci.line.col}{Color to plot confidence interval around estimated treatment effect. Default is blue.}

\item{...}{Further arguments to be passed to \code{print.FRTCI.test()}}
}
\description{
Plot curve from FRTCI.test object.
}
\examples{
Z <- rep(c(0, 1), 100)
tau <- 4
Y <- ifelse(Z, rnorm(100, tau), rnorm(100, 0))
df <- data.frame(Y=Y, Z=Z)
tst <- detect_idiosyncratic(Y ~ Z, df, B = 50, grid.size = 50)
plot(tst)

}
