% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_frt.R
\name{get_tau_vector}
\alias{get_tau_vector}
\title{Generate a grid of treatment effect values to test}
\usage{
get_tau_vector(
  Y,
  Z,
  X = NULL,
  gamma = 0.001,
  grid.size = 21,
  grid.gamma = 100 * gamma
)
}
\arguments{
\item{Y}{Outcome vector.}

\item{Z}{Treatment assignment vector (0/1).}

\item{X}{Optional covariate matrix for regression-adjusted estimation.}

\item{gamma}{Width of the confidence interval. Default is 0.001.}

\item{grid.size}{Number of grid points. Default is 21.}

\item{grid.gamma}{Controls oversampling density near the estimate. Default is 100*gamma.}
}
\value{
A numeric vector of tau values with attributes \code{te.hat},
  \code{te.se}, and \code{te.MOE}.
}
\description{
Creates a sequence of tau values spanning a confidence interval around
the estimated treatment effect, with oversampling near the point estimate.
}
\keyword{internal}
