% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_stat_calc.R
\name{WSKS_t}
\alias{WSKS_t}
\title{WSKS_t}
\usage{
WSKS_t(Y, Z, W)
}
\arguments{
\item{Y}{Observed outcome vector}

\item{Z}{Treatment assigment vector}

\item{W}{A a factor or categorical covariate.}
}
\value{
The value of the test.
}
\description{
Weighted average of the group-level SKS statistics.  This is useful for a
blocked experiment.
}
\examples{
df <- make_randomized_dat( 1000, gamma.vec=c(1,1,1,2), beta.vec=c(-1,-1,1,0) )
df$W <- sample(c("A", "B", "C"), nrow(df), replace = TRUE)
WSKS_t(df$Yobs, df$Z, df$W)

}
