% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_summary_ls.R
\name{print.ls}
\alias{print.ls}
\alias{summary.ls}
\title{Print and Summary Methods for \code{"ls"} Objects}
\usage{
\method{print}{ls}(x, ...)

\method{summary}{ls}(object, ...)
}
\arguments{
\item{x}{An object of class \code{"ls"} for \code{print.ls}.}

\item{...}{Additional arguments for consistency with S3 methods (unused).}

\item{object}{An object of class \code{"ls"} for \code{summary.ls}.}
}
\value{
\describe{

  \item{\code{print.ls}}{
    Prints the structural objects to the console.  
    Invisibly returns the original \code{"ls"} object so that it may be used
    in further computations.
  }

  \item{\code{summary.ls}}{
    Returns a list with class \code{"summary.ls"} containing:
      \itemize{
        \item \code{str_objects} – vector of structural objects.
        \item \code{rand_template} – a template vector
          indicating how to populate \code{rand.objects} for
          \code{hasserls()}.
        \item \code{str_rand_map} – two-column matrix showing
          structural objects and user-editable randomisation objects.
        \item \code{notes} – guidance text for using this information in
          \code{hasserls()}.
      }

    Unlike \code{print.ls}, this method is designed for programmatic
    inspection, returning structured data without printing.
  }
}
}
\description{
These functions provide printing and summarising methods for objects of
class \code{"ls"}, which are returned from
\code{\link[hassediagrams]{hasselayout}}.
}
\details{
Objects of class \code{"ls"} contain:  
(i) the structural objects of the layout structure;  
(ii) a template randomisation objects vector; and  
(iii) a combined mapping matrix showing structural objects alongside editable
placeholders for the randomisation objects used in
\code{\link[hassediagrams]{hasserls}}.

The \code{print} method displays the structural objects.  
The \code{summary} method returns a structured object for programmatic use.
}
\note{
See \code{\link[hassediagrams]{hasserls}} for examples demonstrating how
to use the output of \code{hasselayout()} to construct the restricted layout
structure.
}
\author{
Damianos Michaelides, Simon Bate, and Marion Chatfield
}
