% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gutenberg_cache.R
\name{gutenberg_cache_set}
\alias{gutenberg_cache_set}
\title{Set the Gutenberg cache type}
\usage{
gutenberg_cache_set(
  type = getOption("gutenbergr_cache_type", "session"),
  verbose = TRUE
)
}
\arguments{
\item{type}{Either \code{"session"} (default) or \code{"persistent"}.
\itemize{
\item \code{"session"}: Files are stored in a \code{\link[=tempdir]{tempdir()}}.
This is the default behavior.
\item \code{"persistent"}: Files are stored in an OS-specific
user cache directory under \verb{works_rds/}. These files persist across sessions,
preventing redundant downloads of the same files in the future.
}}

\item{verbose}{Whether to show the status message confirming the path.}
}
\value{
The active cache path (invisibly).
}
\description{
Configures whether the cache should be temporary (per-session) or
persistent across sessions.
}
\section{Cache options}{

The following options control caching behavior:
\itemize{
\item \code{gutenbergr_cache_type}: Character string indicating how downloaded works
are cached. Must be either \code{"session"} (default) or \code{"persistent"}.
\item \code{gutenbergr_base_cache_dir}: Base directory used for persistent caching when
\code{gutenbergr_cache_type = "persistent"}.
By default, this is an OS-specific cache directory determined by
\code{tools::R_user_dir("gutenbergr", "cache")}. Advanced users may set this
to a custom path.
}
}

\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
# Set to persistent (survives R sessions)
gutenberg_cache_set("persistent")

# Set back to session cache (temporary)
gutenberg_cache_set("session")

# Check current cache location
gutenberg_cache_dir()
\dontshow{\}) # examplesIf}
}
\keyword{cache}
