% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale-brain.R
\name{scale_brain}
\alias{scale_brain}
\alias{scale_colour_brain}
\alias{scale_color_brain}
\alias{scale_fill_brain}
\title{Colour and fill scales from brain atlas palettes}
\usage{
scale_brain(
  name = "dk",
  na.value = "grey",
  ...,
  aesthetics = c("fill", "colour", "color")
)

scale_colour_brain(name = "dk", na.value = "grey", ...)

scale_color_brain(name = "dk", na.value = "grey", ...)

scale_fill_brain(name = "dk", na.value = "grey", ...)
}
\arguments{
\item{name}{String name of the atlas palette (e.g. `"dk"`, `"aseg"`).}

\item{na.value}{Colour for `NA` entries (default: `"grey"`).}

\item{...}{Additional arguments passed to [ggseg.formats::atlas_palette()].}

\item{aesthetics}{Which aesthetic to scale: `"fill"`, `"colour"`, or
`"color"`.}
}
\value{
A ggplot2 scale object.
}
\description{
`r lifecycle::badge("deprecated")`

Atlas palettes are now applied automatically by [geom_brain()].
Use [scale_fill_brain_manual()] for custom palettes.
}
\examples{
\dontrun{
library(ggplot2)
ggplot() +
  geom_brain(atlas = dk(), aes(fill = region), show.legend = FALSE) +
  scale_brain("dk")
}

}
