% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_utils.R
\name{calculate_log2_fold_change}
\alias{calculate_log2_fold_change}
\title{Calculate log2 fold change with consistent pseudocount handling}
\usage{
calculate_log2_fold_change(
  mean1,
  mean2,
  pseudocount = NULL,
  reference_values = NULL
)
}
\arguments{
\item{mean1}{Numeric. Mean abundance of group 1 (reference/control)}

\item{mean2}{Numeric. Mean abundance of group 2 (comparison/treatment)}

\item{pseudocount}{Optional numeric. If NULL, calculated from reference_values}

\item{reference_values}{Optional numeric vector for calculating pseudocount}
}
\value{
log2(mean2/mean1) with pseudocount protection
}
\description{
Calculates log2 fold change between two groups with proper handling
of zero values using a data-driven pseudocount approach.
}
\details{
The fold change direction is group2/group1, so:
- Positive values indicate higher abundance in group2
- Negative values indicate higher abundance in group1
}
\keyword{internal}
