% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autograd.R
\name{with_grad_tape}
\alias{with_grad_tape}
\title{Run code with gradient tape enabled}
\usage{
with_grad_tape(expr)
}
\arguments{
\item{expr}{Expression to evaluate under gradient tape}
}
\value{
Value of last expression in expr (invisibly)
}
\description{
Records all ag_* operations inside \code{expr} for later \code{backward()}.
When the default device is \code{"gpu"}, the ggml context is reset at the
start of each tape.
}
\examples{
\donttest{
w <- ag_param(matrix(c(1, 0, 0, 1), 2, 2))
x <- ag_tensor(matrix(c(1, 2), 2, 1))
y <- ag_tensor(matrix(c(1, 2), 2, 1))
with_grad_tape({
  out  <- ag_matmul(w, x)
  loss <- ag_mse_loss(out, y)
})
backward(loss)
}
}
