% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{ggml_mul_mat}
\alias{ggml_mul_mat}
\title{Matrix Multiplication (Graph)}
\usage{
ggml_mul_mat(ctx, a, b)
}
\arguments{
\item{ctx}{GGML context}

\item{a}{First matrix tensor}

\item{b}{Second matrix tensor}
}
\value{
Tensor representing the matrix multiplication
}
\description{
Creates a graph node for matrix multiplication. CRITICAL for LLM operations.
For matrices A (m x n) and B (n x p), computes C = A * B (m x p).
}
\examples{
\donttest{
ctx <- ggml_init(1024 * 1024)
A <- ggml_new_tensor_2d(ctx, GGML_TYPE_F32, 4, 3)
B <- ggml_new_tensor_2d(ctx, GGML_TYPE_F32, 4, 2)
ggml_set_f32(A, 1:12)
ggml_set_f32(B, 1:8)
C <- ggml_mul_mat(ctx, A, B)
graph <- ggml_build_forward_expand(ctx, C)
ggml_graph_compute(ctx, graph)
ggml_get_f32(C)
ggml_free(ctx)
}
}
