% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn_layers.R
\name{ggml_layer_batch_norm}
\alias{ggml_layer_batch_norm}
\title{Add Batch Normalization Layer}
\usage{
ggml_layer_batch_norm(model, eps = 1e-05, name = NULL, trainable = TRUE)
}
\arguments{
\item{model}{A ggml_sequential_model object}

\item{eps}{Small constant for numerical stability (default 1e-5)}

\item{name}{Optional character name for the layer.}

\item{trainable}{Logical; whether the layer weights are updated during training.}
}
\value{
The model object with the batch_norm layer appended (invisibly).
}
\description{
Applies normalization: RMS-normalizes the input, then scales by gamma
and shifts by beta (both learnable). Uses \code{ggml_rms_norm} which
supports backward pass for training.
}
\examples{
\donttest{
model <- ggml_model_sequential() |>
  ggml_layer_dense(128, input_shape = 784) |>
  ggml_layer_batch_norm() |>
  ggml_layer_dense(10, activation = "softmax")
}
}
