% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legend_multi.R
\name{legend_select}
\alias{legend_select}
\title{Keep Only Specific Legends}
\usage{
legend_select(...)
}
\arguments{
\item{...}{Aesthetic names (unquoted) to keep. All other legends will be
hidden. Common values: \code{colour}, \code{fill}, \code{size},
\code{shape}, \code{linetype}, \code{alpha}.}
}
\value{
A guides specification that can be added to a plot, or \code{NULL}
if nothing needs to be hidden.
}
\description{
Show only the specified legends and hide all others. This is the inverse of
\code{\link{legend_hide}}.
}
\examples{
library(ggplot2)

# Plot with multiple legends
p <- ggplot(mtcars, aes(mpg, wt, color = factor(cyl), size = hp,
                         shape = factor(am))) +
  geom_point()

# Keep only the colour legend
p + legend_select(colour)

# Keep colour and shape, hide size
p + legend_select(colour, shape)

}
\seealso{
\code{\link{legend_hide}}, \code{\link{legend_none}}
}
