% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FourPHFfit.R
\name{FourPHFfit}
\alias{FourPHFfit}
\title{Fit four-parameter hill function}
\usage{
FourPHFfit(
  germ.counts,
  intervals,
  total.seeds,
  partial = TRUE,
  fix.y0 = TRUE,
  fix.a = TRUE,
  tmax,
  xp = c(10, 60),
  umin = 10,
  umax = 90,
  tries = 3
)
}
\arguments{
\item{germ.counts}{Germination counts at each time interval. Can be partial
or cumulative as specified in the argument \code{partial}.}

\item{intervals}{The time intervals.}

\item{total.seeds}{Total number of seeds.}

\item{partial}{logical. If \code{TRUE}, \code{germ.counts} is considered as
partial and if \code{FALSE}, it is considered as cumulative. Default is
\code{TRUE}.}

\item{fix.y0}{Force the intercept of the y axis through 0.}

\item{fix.a}{Fix a as the actual maximum germination percentage at the end of
the experiment.}

\item{tmax}{The time up to which AUC is to be computed.}

\item{xp}{Germination percentage value(s) for which the corresponding time is
to be computed as a numeric vector. Default is \code{c(10, 60)}.}

\item{umin}{The minimum germination percentage value for computing
uniformity. Default is \code{10}. Seed \strong{\code{Details}}.}

\item{umax}{The maximum germination percentage value for computing
uniformity. Default is \code{90}. Seed \strong{\code{Details}}.}

\item{tries}{The number of tries to be attempted to fit the curve. Default is
3.}
}
\value{
A list with the following components: \item{data}{A data frame with
  the data used for computing the model.} \item{Parameters}{A data frame of
  parameter estimates, standard errors and p value.}  \item{Fit}{A one-row
  data frame with estimates of model fitness such as log likelyhoods, Akaike
  Information Criterion, Bayesian Information Criterion, deviance and
  residual degrees of freedom.}  \item{a}{The asymptote or the maximum
  cumulative germination percentage.}  \item{b}{The mathematical parameter
  controlling the shape and steepness of the germination curve.} \item{c}{The
  half-maximal activation level.}  \item{y0}{The intercept on the y axis.}
  \item{lag}{Time at germination onset.} \item{Dlag50}{duration between the
  time at germination onset (lag) and that at 50\% germination.}
  \item{t50.total}{Time required for 50\% of total seeds to germinate. Will
  be \code{NaN} if more than 50\% of total seeds do not germinate.}
  \item{txp.total}{Time required for x\% (as specified in argument \code{xp})
  of total seeds to germinate. Will be \code{NaN} if more than x\% of total
  seeds do not germinate.} \item{t50.Germinated}{Time required for 50\%
  of viable/germinated seeds to germinate.} \item{txp.Germinated}{Time
  required for x\% (as specified in argument \code{xp}) of viable/germinated
  seeds to germinate.} \item{Uniformity}{Time interval between \code{umin}\%
  and \code{umax}\% of viable seeds to germinate.} \item{TMGR}{Time at
  maximum germination rate.} \item{AUC}{The estimate of area under the
  curve.} \item{MGT}{Mean germination time.} \item{Skewness}{Skewness of mean
  germination time.} \item{msg}{The message from
  \code{\link[gslnls]{gsl_nls}}.} \item{isConv}{Logical value indicating
  whether convergence was achieved.}
  \item{model}{The raw fitted model output as a list of class
  \code{gsl_nls}.}
}
\description{
Fit a four-parameter hill function
\insertCite{el-kassaby_seed_2008}{germinationmetrics} to cumulative
germination count data and compute the associated parameters. \loadmathjax
}
\details{
The cumulative germination count data of a seed lot can be modelled to fit a
four-parameter hill function defined as follows
\insertCite{el-kassaby_seed_2008}{germinationmetrics}.

\mjsdeqn{y = y_{0}+\frac{ax^{b}}{c^{b}+x^{b}}}

Where, \mjseqn{y} is the cumulative germination percentage at time
\mjseqn{x}, \mjseqn{y_{0}} is the intercept on the y axis, \mjseqn{a} is the
asymptote, or maximum cumulative germination percentage, which is equivalent
to germination capacity, \mjseqn{b} is a mathematical parameter controlling
the shape and steepness of the germination curve (the larger the \mjseqn{b}
parameter, the steeper the rise toward the asymptote \mjseqn{a}, and the
shorter the time between germination onset and maximum germination), and
\mjseqn{c} is the "half-maximal activation level" which represents the time
required for 50\% of viable seeds to germinate (\mjseqn{c} is equivalent to
the germination speed).

In \code{FourPHFfit}, this model has be reparameterized by substituting
\mjseqn{b} with \mjseqn{e^{\beta}} to constraint \mjseqn{b} to positive
values only.

\mjsdeqn{y = y_{0}+\frac{ax^{e^{\beta}}}{c^{e^{\beta}}+x^{e^{\beta}}}}

Where, \mjseqn{b = e^{\beta}} and \mjseqn{\beta = \log_{e}(b)}.

The curve fitting is performed with nonlinear
\code{\link[gslnls:gsl_nls]{gslnls}} package, a R interface to the
least-squares optimization with the GNU Scientific Library (GSL) with the
Levenberg-Marquardt algorithm
\insertCite{galassi_gnu_2009,chau_gslnls_2023}{germinationmetrics}.

Once this function is fitted to the curve, \code{FourPHFfit} computes the
time to 50\% germination of total seeds (\code{t50.total}) or viable seeds
(\code{t50.Germinated}). Similarly the time at any percentage of germination
(in terms of both total and viable seeds) as specified in argument \code{xp}
can be computed.

The time at germination onset (\mjseqn{lag}) can be computed as follows.

\mjsdeqn{lag = b\sqrt{\frac{-y_{0}c^{b}}{a + y_{0}}}}

The value \mjseqn{D_{lag-50}} is defined as the duration between the time at
germination onset (lag) and that at 50\% germination (\mjseqn{c}).

The time interval between the percentages of viable seeds specified in the
arguments \code{umin} and \code{umin} to germinate is computed as uniformity
(\mjseqn{U_{t_{max}-t_{min}}}).

\mjsdeqn{U_{t_{max}-t_{min}} = t_{max} - t_{min}}

The partial derivative of the four-parameter hill function gives the
instantaneous rate of germination (\mjseqn{s}) as follows.

\mjsdeqn{s = \frac{\partial y}{\partial x} =
\frac{abc^{b}x^{b-1}}{(c^{b}+x^{b})^{2}}}

From this function for instantaneous rate of germination, the time at maximum
germination rate (\mjseqn{TMGR}) can be estimated as follows.

\mjsdeqn{TMGR = b \sqrt{\frac{c^{b}(b-1)}{b+1}}}

TMGR represents the point in time when the instantaneous rate of germination
starts to decline.

The area under the curve (\mjseqn{AUC}) is obined by integration of the
fitted curve between time 0 and time specified in the argument `tmax`.

Integration of the fitted curve gives the value of mean germination time
(\mjseqn{MGT}) and the skewness of the germination curve is computed as the
ratio of \mjseqn{MGT} and the time for 50\% of viable seeds to germinate
(\mjseqn{t_{50}}).

\mjsdeqn{Skewness = \frac{MGT}{t_{50}}}

If final germination percentage is less than 10\%, a warning is given, as the
results may not be informative.
}
\examples{

x <- c(0, 0, 0, 0, 4, 17, 10, 7, 1, 0, 1, 0, 0, 0)
y <- c(0, 0, 0, 0, 4, 21, 31, 38, 39, 39, 40, 40, 40, 40)
int <- 1:length(x)
total.seeds = 50

# From partial germination counts
#----------------------------------------------------------------------------
FourPHFfit(germ.counts = x, intervals = int, total.seeds = 50, tmax = 20)

# From cumulative germination counts
#----------------------------------------------------------------------------
FourPHFfit(germ.counts = y, intervals = int, total.seeds = 50, tmax = 20,
           partial = FALSE)

}
\references{
\insertAllCited{}
}
