#' Function that generates the test database
#'
#' The example_database function reads a csv file available on the computer system and returns a dataframe as an example of a database to be used by the functions of the bibliorefer package
#'
#' @param path_date is a directory path containing the csv file
#'
#' @importFrom utils read.csv2
#' @return This function return is a dataframe with database
#' @export
#'
#' @references
#' Aria, M. & Cuccurullo, C. (2017) bibliometrix: An R-tool for comprehensive science mapping analysis, Journal of Informetrics, 11(4), pp 959-975, Elsevier
#'
#' @examples
#'
#' #Call the example_database function
#'
#' file_db <- system.file("extdata","example_databaseart.csv", package = "gerefer")
#'
#' date_sreference <- example_databaseart(file_db)
#' date_sreference
#'
#'
example_databaseart <- function(path_date){

  date_package <- read.csv2(path_date)

  return(date_package)
}
