% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attachGeoArrowDependencies.R
\name{attachGeoarrowDependencies}
\alias{attachGeoarrowDependencies}
\alias{attachGeoarrowDependency}
\alias{attachArrowDependency}
\alias{attachParquetWasmDependencies}
\title{Attach \verb{(Geo)Arrow} and/or \verb{(Geo)Parquet} JavaScript dependencies to a widget.}
\usage{
attachGeoarrowDependencies(widget)

attachGeoarrowDependency(widget)

attachArrowDependency(widget)

attachParquetWasmDependencies(widget)
}
\arguments{
\item{widget}{A widget created with \code{\link[htmlwidgets]{createWidget}}.}
}
\value{
The \code{widget} including \code{Arrow}, \code{Geoarrow} and/or \code{parquet-wasm}
JavaScript dependencies.
}
\description{
Pipe-friendly functions to attach \verb{(Geo)Arrow} and/or \verb{(Geo)Parquet}
JavaScript dependencies to a widget created with
\code{\link[htmlwidgets]{createWidget}}.
}
\details{
Attaching the \code{parquet-wasm} JavaScript dependency differs from attaching
the other dependencies. In order to enable reading \code{.parquet} files in the
browser we declare an \code{async} function \code{parquet2arrow} at the \code{window} level
that can be used to read parquet data into an \code{Arrow} memory table in the
browser. As such, \code{attachParquetWasmDependencies()} will also attach the
\code{arrow} and \code{geoarrow} dependencies.

So, in the browser, we can use this as follows:

\if{html}{\out{<div class="sourceCode">}}\preformatted{  fetch(<(geo)parquet-url>)
    .then(pq => window.parquet2arrow(pq))
    .then(arrow_table => \{

     // code to work with arrow table

    \});
}\if{html}{\out{</div>}}
}
\examples{
library(listviewer)

wgt = jsonedit(
  list("Just some dummy text")
  , elementId = "lv-example"
)
attachGeoarrowDependencies(wgt)

## open the resulting page in the browser and inspect the page source, e.g.
## by pressing <Ctrl + u>. You should see two lines like:

# <script src="lib/apache-arrow-js-19.0.1/Arrow.es2015.min.js"></script>
# <script src="lib/geoarrow-js-0.3.2/geoarrow.umd.min.js"></script>

## !Version numbers of the JavaScript dependencies may differ!

}
