% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fw_fetchdata.R
\name{fw_fetchdata}
\alias{fw_fetchdata}
\title{Extracting the traits from the downloaded data.}
\usage{
fw_fetchdata(
  data,
  organismgroup,
  ecoparams = NULL,
  taxalevel = "species",
  taxonomic_column = NULL,
  organismgroup_column = NULL,
  apikey = NULL,
  seed = 1134,
  secure = TRUE,
  percenterror = 80,
  errorness = 20,
  warn = FALSE,
  inform = FALSE,
  cachefolder = "cache",
  details = FALSE
)
}
\arguments{
\item{data}{\code{vector}. The list or vector with species names for which
ecological references needs to be extracted from the database.}

\item{organismgroup}{\code{string}. The organism group to download from the
platform. The allowed group includes \code{"fi", "mi", "pp", "pb",
  "di","mp"} for fishes, macroinvertebrates, phytoplankton, phytobenthos,
diatoms, and macrophytes, respectively. Multiple groups allowed, such as
\code{'pp', 'di'}.
\itemize{
\item{\code{pp}: Pytoplankton.}
\item{\code{mp}: Macrophytes}
\item{\code{mi}: Macroinvertebrates}
\item{\code{fi}: Fishes}
\item{\code{di}: Diatoms}
\item{\code{pb}: Phytobenthos without diatoms}
}}

\item{ecoparams}{\code{vector}. Selected traits that should be downloaded for
a particular organism group. Check \code{\link{fw_dbguide}} for the allowed
traits in the database.}

\item{taxalevel}{\code{string} Allowed taxonomic levels at which data can be
retrieved. Default is \code{'species'} but data can also be downloaded at
\code{family}, \code{genus}, and \code{taxagroup} level.}

\item{taxonomic_column}{\code{string}. If the data is a dataframe, the
species column is required and provided in this parameter. The column
should have complete species name and not genus and species provided
separately.}

\item{organismgroup_column}{\code{string} If the data is a dataframe, and
more than one taxonomic group exists in the data, the
\code{organismgroup_column} is required to iterate over the taxonomic
groups separately.}

\item{apikey}{\code{string}. The API key is automatically loaded using
the loadapikey() internal function.}

\item{seed}{\code{integer}. An integer to help track the caching of the
access token generated during data collation. If a user wants a new token,
the seed should be changed.}

\item{secure}{\code{logical}. If \code{TRUE}, the User will be prompted to
set the API key in the .Renviron file by running the
\code{\link{fw_setapikey}} function. The User must strictly type in API_KEY
= 'api key', save, close the file and restart the R session or RStudio for
the API_KEY environment to be captured. If \code{FALSE}, then the key will
be entered directly in the API_KEY directly in the fw_token() function.
This method is insecure, since other users can obtain the key from the codes.}

\item{percenterror}{\code{numeric}. The number used as a cutoff to infer similarity of the user provided name and what is found in the database.
The higher the percentage, the higher the similarity the species name provided by the user and the one in the database. \code{percenterror}
ranges from 0 to 100 but the default is 80 to ensure that wrong names are not selected at low similarity percentage cutoff.}

\item{errorness}{\code{numeric} Similar to \code{percenterror}, \code{errorness} parameter uses the distance differences between the user-provided
names and all the taxa group species standard names. The lower the percentage error, the higher the similarity in the species
names provided. Default is 20 and beyond 30, a warning is showed to avoid wrong species replace the user provided name, which leads
to extracting wrong traits.}

\item{warn}{\code{logical} To show species name warning checks and traits cleaning. Default \code{FALSE}.}

\item{inform}{\code{logical}. This is to indicate if the token has been
successfully generated. Default \code{TRUE}.}

\item{cachefolder}{\code{string}. The root path were the cached data will be
saved on the user PC. If the path is not provided, the cached information
will be saved in the current working directly.}

\item{details}{\code{loical}. Outputs the downloaded details including the organism groups
considered by the user, the functional call, and whether some groups were successful
in retrieving data.}
}
\value{
\code{dataframe} The output has four sections, including
\itemize{
\item ecodata, which is the complete dataframe with all the taxonomic
names and ecological parameters.
\ item taxasearch: is a table with the taxonomic names,both original and cleaned names.
\item fetch: an indication that data has been fetched from
www.freshwaterecology.info.
\item fun_call: A functional call used internally to review the data
cleaning process.
}
}
\description{
Extracting the traits from the downloaded data.
}
\examples{

\dontrun{

dfextract <- fw_fetchdata(data = "Abramis brama", organismgroup = 'fi', inform = TRUE,
                            ecoparams = 'migration', cachefolder = 'cache' )

}

}
