% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmfcc.R
\name{RoAMFEWMA_PhaseII}
\alias{RoAMFEWMA_PhaseII}
\title{Robust Adaptive Multivariate Functional EWMA Control Chart - Phase II}
\usage{
RoAMFEWMA_PhaseII(mfdobj_2, mod_1, n_seq_2 = 1, l_seq_2 = 2000)
}
\arguments{
\item{mfdobj_2}{An object of class \code{mfd} containing the Phase II multivariate
functional data set, to be monitored with the RoAMFEWMA control chart.}

\item{mod_1}{The output of the Phase I achieved through the
\code{\link{RoAMFEWMA_PhaseI}} function.}

\item{n_seq_2}{If it is 1, the Phase II monitoring statistic is calculated on
the data sequence.
If it is an integer number larger than 1, a number \code{n_seq_2} of
bootstrap sequences are sampled with replacement from \code{mfdobj_2}
to allow uncertainty quantification on the estimation of the run length.
Default value is 1.}

\item{l_seq_2}{If \code{n_seq_2} is larger than 1, this parameter sets the
length of each bootstrap sequence to be generated.
Default value is 2000.}
}
\value{
A list with the following elements.
\itemize{
\item \code{ARL_2}: the average run length estimated over the
bootstrap sequences. If \code{n_seq_2} is 1, it is simply the run length
observed over the Phase II sequence, i.e., the number of observations
up to the first alarm,
\item \code{RL}: the run length
observed over the Phase II sequence, i.e., the number of observations
up to the first alarm,
\item \code{V2}: a list with length \code{n_seq_2}, containing the
AMFEWMA monitoring statistic in Equation (8) of Capezza
et al. (2024), calculated in each bootstrap sequence, until the first alarm.
\item \code{cc}: a data frame with the information needed to plot the
AMFEWMA control chart in Phase II, with the following columns.
\code{id} contains the id of each multivariate functional observation,
\code{amfewma_monitoring_statistic} contains the AMFEWMA monitoring
statistic values calculated on the Phase II sequence,
\code{amfewma_monitoring_statistic_lim} is the upper control limit.
}
}
\description{
This function performs Phase II of the Robust Adaptive Multivariate
Functional EWMA (RoAMFEWMA) control chart.
}
\details{
This function is conceptually similar to \code{AMFEWMA_PhaseII}, proposed
by Capezza et al. (2024), but adapted to the RoAMFEWMA framework.
In Phase II, monitoring relies on the RoAMFEWMA model calibrated in Phase I
on data cleaned from both cellwise and casewise outliers.
The monitoring statistic, control limit, and bootstrap-based ARL estimation
remain unchanged, but the input model must be the robust one obtained
through \code{RoAMFEWMA_PhaseI}.
}
\examples{
\dontrun{
set.seed(0)
dat_phaseI <- simulate_data_RoMFCC(p_cellwise = 0.05,
                            p_casewise = 0.05,
                            outlier = "outlier_E",
                            M_outlier_cell = 0.03,
                            M_outlier_case = 0.01,
                            max_n_cellwise = 10)
dat_phaseII <- simulate_data_RoMFCC(OC = "OC_E",
                                    M_OC = 0.01,
                                    which_OC = 5)
mfdobj_phaseI <- get_mfd_list(dat_phaseI$X_mat_list, n_basis = 5)
mfdobj_phaseII <- get_mfd_list(dat_phaseII$X_mat_list, n_basis = 5)
mfdobj_training_phaseI <- mfdobj_phaseI[1:333, ]
mfdobj_tuning_phaseI <- mfdobj_phaseI[334:1000, ]
out_phaseI <- RoAMFEWMA_PhaseI(mfdobj = mfdobj_training_phaseI,
                               mfdobj_tuning = mfdobj_tuning_phaseI)
out_phaseII <- RoAMFEWMA_PhaseII(mfdobj_2 = mfdobj_phaseII,
                                 mod_1 = out_phaseI)
plot_control_charts(out_phaseII$cc)
}
}
\references{
Capezza, C., Capizzi, G., Centofanti, F., Lepore, A., Palumbo, B. (2025)
An Adaptive Multivariate Functional EWMA Control Chart.
\emph{Journal of Quality Technology},  57(1):1--15,
doi:https://doi.org/10.1080/00224065.2024.2383674.
}
