% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/augment_rows.R
\name{set_header_footer_df}
\alias{set_header_footer_df}
\alias{set_header_df}
\alias{set_footer_df}
\title{Replace the entire header or footer from a data frame}
\usage{
set_header_df(x, mapping = NULL, key = "col_keys")

set_footer_df(x, mapping = NULL, key = "col_keys")
}
\arguments{
\item{x}{a 'flextable' object, see \link{flextable-package} to learn how to create
'flextable' object.}

\item{mapping}{a \code{data.frame} specyfing for each colname
content of the column.}

\item{key}{column to use as key when joigning data_mapping.}
}
\description{
Replace all header or footer rows using a mapping data frame.
Unlike \code{\link[=set_header_labels]{set_header_labels()}} which only renames the bottom header row,
this function rebuilds the entire header (or footer) structure.

The data.frame must contain a column whose values match flextable
\code{col_keys} argument, this column will be used as join key. The
other columns will be displayed as header or footer rows. The leftmost column
is used as the top header/footer row and the rightmost column
is used as the bottom header/footer row.
}
\examples{
typology <- data.frame(
  col_keys = c(
    "Sepal.Length", "Sepal.Width", "Petal.Length",
    "Petal.Width", "Species"
  ),
  what = c("Sepal", "Sepal", "Petal", "Petal", "Species"),
  measure = c("Length", "Width", "Length", "Width", "Species"),
  stringsAsFactors = FALSE
)

ft_1 <- flextable(head(iris))
ft_1 <- set_header_df(ft_1, mapping = typology, key = "col_keys")
ft_1 <- merge_h(ft_1, part = "header")
ft_1 <- merge_v(ft_1, j = "Species", part = "header")
ft_1 <- theme_vanilla(ft_1)
ft_1 <- fix_border_issues(ft_1)
ft_1


typology <- data.frame(
  col_keys = c(
    "Sepal.Length", "Sepal.Width", "Petal.Length",
    "Petal.Width", "Species"
  ),
  unit = c("(cm)", "(cm)", "(cm)", "(cm)", ""),
  stringsAsFactors = FALSE
)
ft_2 <- set_footer_df(ft_1, mapping = typology, key = "col_keys")
ft_2 <- italic(ft_2, italic = TRUE, part = "footer")
ft_2 <- theme_booktabs(ft_2)
ft_2 <- fix_border_issues(ft_2)
ft_2
}
\seealso{
Other functions for row and column operations in a flextable: 
\code{\link{add_body}()},
\code{\link{add_body_row}()},
\code{\link{add_footer}()},
\code{\link{add_footer_lines}()},
\code{\link{add_footer_row}()},
\code{\link{add_header}()},
\code{\link{add_header_lines}()},
\code{\link{add_header_row}()},
\code{\link{delete_columns}()},
\code{\link{delete_part}()},
\code{\link{separate_header}()},
\code{\link{set_header_labels}()}
}
\concept{functions for row and column operations in a flextable}
