% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcom.R
\name{COMDistribution}
\alias{COMDistribution}
\alias{dcom}
\alias{pcom}
\alias{qcom}
\alias{rcom}
\title{Conway-Maxwell-Poisson (COM) Distribution}
\usage{
dcom(x, mu = NULL, lambda = 1, nu = 1, log = FALSE)

pcom(q, mu = NULL, lambda = 1, nu = 1, lower.tail = TRUE, log.p = FALSE)

qcom(p, mu = NULL, lambda = 1, nu = 1)

rcom(n, mu = NULL, lambda = 1, nu = 1)
}
\arguments{
\item{x}{numeric value or a vector of values.}

\item{mu}{optional. Numeric value or vector of mean values for the
distribution (the values have to be greater than 0).}

\item{lambda}{optional. Numeric value or vector of values for the rate
parameter of the distribution (the values have to be greater than 0).
If `mu` is provided, `lambda` is ignored.}

\item{nu}{optional. Numeric value or vector of values for the decay
parameter of the distribution ((the values have to be greater than 0).}

\item{log}{logical; if TRUE, probabilities p are given as log(p).}

\item{q}{quantile or a vector of quantiles.}

\item{lower.tail}{logical; if TRUE, probabilities p are \eqn{P[X\leq x]}
otherwise, \eqn{P[X>x]}.}

\item{log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{p}{probability or a vector of probabilities.}

\item{n}{the number of random numbers to generate.}
}
\value{
dcom gives the density, pcom gives the distribution function, qcom 
 gives the quantile function, and rcom generates random deviates.

 The length of the result is determined by n for rcom, and is the maximum of 
 the lengths of the numerical arguments for the other functions.

 The numerical arguments other than n are recycled to the length of the 
 result. Only the first elements of the logical arguments are used.
}
\description{
These functions provide the density function, distribution function,
quantile function, and random number generation for the
Conway-Maxwell-Poisson (COM) Distribution
}
\details{
\code{dcom} computes the density (PDF) of the COM Distribution.

\code{pcom} computes the CDF of the COM Distribution.

\code{qcom} computes the quantile function of the COM Distribution.

\code{rcom} generates random numbers from the COM Distribution.

The Probability Mass Function (PMF) for the Conway-Maxwell-Poisson
distribution is:
\deqn{f(x|\lambda, \nu) = \frac{\lambda^x}{(x!)^\nu Z(\lambda,\nu)}}

Where \eqn{\lambda} and \eqn{\nu} are distribution parameters with
\eqn{\lambda>0} and \eqn{\nu>0}, and \eqn{Z(\lambda,\nu)} is the
normalizing constant.

The normalizing constant is given by:
\deqn{Z(\lambda,\nu)=\sum_{n=0}^{\infty}\frac{\lambda^n}{(n!)^\nu}}

The mean and variance of the distribution are given by:
\deqn{E[x]=\mu=\lambda \frac{\delta}{\delta \lambda} \log(Z(\lambda,\nu))}
\deqn{Var(x)=\lambda \frac{\delta}{\delta \lambda} \mu}

When the mean value is given, the rate parameter (\eqn{\lambda}) is
computed using the mean and the decay parameter (\eqn{\nu}). This is
useful to allow the calculation of the rate parameter when the mean is
known (e.g., in regression))
}
\examples{
dcom(1, mu=0.75, nu=3)
pcom(c(0,1,2,3,5,7,9,10), lambda=0.75, nu=0.75)
qcom(c(0.1,0.3,0.5,0.9,0.95), mu=0.75, nu=0.75)
rcom(30, mu=0.75, nu=0.5)

}
