% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernal_estimator.R
\name{MVKE}
\alias{MVKE}
\title{Multivariate vector field kernel estimator}
\usage{
MVKE(d, v, h = 0.2, kernel = c("Gaussian", "exp"))
}
\arguments{
\item{d}{The dataset. Should be a matrix or a data frame, with each row representing a random vector.}

\item{v}{The vectors corresponding to the dataset. Should be a matrix or a data frame with the same shape as \code{d}. If missing, then the vectors will be calculated from the dataset.}

\item{h}{The bandwidth for the kernel estimator.}

\item{kernel}{The type of kernel estimator used. "Gaussian" by default.}
}
\value{
A function(x), which then returns the \eqn{\mu} and \eqn{a} estimators at the position \eqn{x}.
}
\description{
See references for details.
}
\references{
Bandi, F. M., & Moloche, G. (2018). On the functional estimation of multivariate diffusion processes. Econometric Theory, 34(4), 896-946. https://doi.org/10.1017/S0266466617000305
}
