% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitVARMxID-methods-var-mx-id.R
\name{converged}
\alias{converged}
\alias{converged.varmxid}
\title{Check Model Convergence}
\usage{
converged(object, ...)

\method{converged}{varmxid}(object, prop = FALSE, ...)
}
\arguments{
\item{object}{A fit object.}

\item{...}{Passed to and/or used by methods.}

\item{prop}{Logical.
If \code{prop = FALSE}, a named logical vector indicating,
for each individual fit, whether the convergence criteria are met.
If \code{prop = TRUE}, the proportion of cases that converged.}
}
\value{
For the \code{varmxid} method:
If \code{prop = FALSE}, a named logical vector indicating,
for each individual fit, whether the convergence criteria are met.
If \code{prop = TRUE}, the proportion of cases that converged.
}
\description{
Determines whether each fitted \pkg{OpenMx} model in a \code{varmxid} object
meets convergence criteria based on (a) acceptable optimizer status and
gradient size, (b) a positive-definite Hessian, and (c) parameters not being
at their bounds.
}
\author{
Ivan Jacob Agaloos Pesigan
}
\keyword{methods}
