% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{LayeredDAG}
\alias{LayeredDAG}
\title{Layered Directed Acyclic Graph}
\usage{
LayeredDAG(layers, n_manifest = NULL)
}
\arguments{
\item{layers}{list of vectors. Each vector in the list corresponds to a
layer. There are as many layers as items in the list. Alternatively, this
argument can be a vector of the number of variables per layer.}

\item{n_manifest}{vector of the number of manifest (observed) variables
measuring each of the latent variables. If \code{n_manifest} is provided,
the variables defined in argument \code{layers} are considered latent. All
entries of \code{n_manifest} must be strictly positive.}
}
\value{
The adjacency matrix of the layered Directed Acyclic Graph.
}
\description{
Returns the adjacency matrix of a layered Directed Acyclic Graph. In this
graph, arrows go from all members of a layer to all members of the following
layers. There are no arrows between members of the same layer.
}
\examples{
# Example with 3 layers specified in a list
layers <- list(
  c("x1", "x2", "x3"),
  c("x4", "x5"),
  c("x6", "x7", "x8")
)
dag <- LayeredDAG(layers)
plot(dag)

# Example with 3 layers specified in a vector
dag <- LayeredDAG(layers = c(3, 2, 3))
plot(dag)

}
