% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/days.R
\name{days}
\alias{days}
\alias{days_in_year}
\alias{days_in_month}
\title{Days in a year or in a month}
\usage{
days_in_year(year)

days_in_month(year, month)
}
\arguments{
\item{year}{An integer vector. The years of interest.}

\item{month}{An integer vector. A subset of \code{1:12}.The months of interest.}
}
\value{
A numeric vector of the numbers of days in each of the years in
\code{year} or the months specified by \code{year} and \code{month}.
}
\description{
Returns the number of days in each of a vector of years or months.
}
\details{
The length of the output vector is equal to the length of \code{month}.
The argument \code{year} is recycled to the length of the output vector if
necessary.
}
\examples{
days_in_year(1999:2025)

days_in_month(2024, 1:12)
days_in_month(2025, 1:12)
days_in_month(2024:2025, 1:3)
}
