% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_density.R
\name{plot_density}
\alias{plot_density}
\title{plot_density: Univariate Density Plot (Fill Group, Black Outline)}
\usage{
plot_density(
  data,
  x,
  group = NULL,
  facet = NULL,
  palette = c("#1b9e77", "#d95f02", "#7570b3"),
  alpha = 0.7,
  base_size = 14,
  xlab = NULL,
  ylab = "Density",
  title = NULL,
  legend_pos = "right",
  adjust = 1,
  show_mean = FALSE,
  mean_line_color = "red",
  add_hist = FALSE,
  hist_bins = NULL,
  add_rug = FALSE,
  theme = "minimal"
)
}
\arguments{
\item{data}{data.frame. Input dataset.}

\item{x}{Character. Name of numeric variable to plot.}

\item{group}{Character. Grouping variable for fill color. (Optional)}

\item{facet}{Character. Faceting variable. (Optional)}

\item{palette}{Character vector. Fill color palette, e.g. c("#FF0000","#00FF00","#0000FF").
Will be recycled as needed. Cannot be a palette name.
Default: c("#1b9e77", "#d95f02", "#7570b3")}

\item{alpha}{Numeric. Fill transparency. Default: 0.7.}

\item{base_size}{Numeric. Theme base font size. Default: 14.}

\item{xlab}{Character. X-axis label. Default: NULL (uses variable name).}

\item{ylab}{Character. Y-axis label. Default: "Density".}

\item{title}{Character. Plot title. Default: NULL.}

\item{legend_pos}{Character. Legend position. One of "right", "left", "top", "bottom", "none". Default: "right".}

\item{adjust}{Numeric. Density bandwidth adjust. Default: 1.}

\item{show_mean}{Logical. Whether to add mean line. Default: FALSE.}

\item{mean_line_color}{Character. Mean line color. Default: "red".}

\item{add_hist}{Logical. Whether to add histogram layer. Default: FALSE.}

\item{hist_bins}{Integer. Number of histogram bins. Default: NULL (auto).}

\item{add_rug}{Logical. Whether to add rug marks at bottom. Default: FALSE.}

\item{theme}{Character. ggplot2 theme style. One of "minimal", "classic", "bw", "light", "dark". Default: "minimal".}
}
\value{
ggplot object.
}
\description{
Create a density plot with group color as fill, and fixed black border for all curves.
}
