% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VizRobinson.R
\name{VizRobinson}
\alias{VizRobinson}
\title{Plot map in Robinson or other projections}
\usage{
VizRobinson(
  data,
  lon,
  lat,
  lon_dim = NULL,
  lat_dim = NULL,
  target_proj = NULL,
  drawleg = "bar",
  style = "point",
  dots = NULL,
  mask = NULL,
  brks = NULL,
  cols = NULL,
  bar_limits = NULL,
  triangle_ends = NULL,
  col_inf = NULL,
  col_sup = NULL,
  colNA = NULL,
  color_fun = ClimPalette(),
  bar_extra_margin = rep(0, 4),
  vertical = TRUE,
  toptitle = NULL,
  caption = NULL,
  units = NULL,
  crop_coastlines = NULL,
  point_size = "auto",
  title_scale = 16,
  title_size = NULL,
  dot_size = 0.5,
  dots_size = NULL,
  dot_symbol = 47,
  dots_shape = NULL,
  coast_width = 0.3,
  coastlines_width = NULL,
  fileout = NULL,
  width = 8,
  height = 4,
  size_units = "in",
  res = 300
)
}
\arguments{
\item{data}{A numeric array with longitude and latitude dimensions. The grid
should be regular grid. It can contain NA values.}

\item{lon}{A numeric vector of longitude locations of the cell centers of the 
grid of 'data'. Expected to be regularly spaced, within the range of either
[-180, 180] or [0, 360].}

\item{lat}{A numeric vector of latitude locations of the cell centers of the 
grid of 'data'. Expected to be regularly spaced, within the range [-90, 90]
of ascending or descending order.}

\item{lon_dim}{A character string indicating the longitude dimension name in
'data'. If it is NULL, the function tries to find the name in 
\code{esviz:::.KnownLonNames}. The default value is NULL.}

\item{lat_dim}{A character string indicating the latitude dimension name in
'data'. If it is NULL, the function tries to find the name in 
\code{esviz:::.KnownLatNames}. The default value is NULL.}

\item{target_proj}{A character string indicating the target projection. It 
should be a valid crs string. The default projection is Robinson: 
"ESRI:54030". Note that the character string may work differently depending
on PROJ and GDAL module version. If package version 'sf' is lower than 
"1.0.10" and an error appears regarding the target crs, you can try with 
numeric crs (e.g. target_proj = 54030).}

\item{drawleg}{A character string indicating the legend style. It can be 
'bar' (color bar by \code{ColorBarContinuous()}), 'ggplot2' (discrete legend 
by ggplot2), or FALSE (no legend). The default value is 'bar'.}

\item{style}{A character string indicating the plotting style. It can be 
'point' or 'polygon'. The default value is 'point'. Note that 'polygon' may
be time- and memory-consuming for global or high-resolution data.}

\item{dots}{An array with the same dimensions as 'data' of [0, 1] or logical
indicating the grids to plot dots. The value 0 or FALSE is the point to be
dotted.}

\item{mask}{An array with the same dimensions as 'data' of [0, 1] or logical
indicating the grids to not plot data. The value 0 or FALSE is the point not
to be plotted.}

\item{brks, cols, bar_limits, triangle_ends}{Usually only providing 'brks' is 
enough to generate the desired color bar. These parameters allow to 
define n breaks that define n - 1 intervals to classify each of the values 
in 'data'. The corresponding grid cell of a given value in 'data' will be 
colored in function of the interval it belongs to. These parameters are 
sent to \code{ColorBarContinuous()} to generate the breaks and colours. 
Additional colors for values beyond the limits of the colour bar are also 
generated and applied to the plot if 'bar_limits' or 'brks' and 
'triangle_ends' are properly provided to do so. See ?ColorBarContinuous for
a full explanation.}

\item{col_inf, col_sup, colNA}{Colour identifiers to color the values that 
excess the extremes of the color bar and to color NAs, respectively. 'colNA'
takes attr(cols, 'na_color') if available by default, where cols is the 
parameter 'cols' if provided or the vector of colors returned by 
'color_fun'. 'col_inf' and 'col_sup' will take the value of 'colNA' if not 
specified. See ?ColorBarContinuous for a full explanation.}

\item{color_fun, bar_extra_margin}{Set of 
parameters to control the visual aspect of the drawn colour bar 
(1/3). See ?ColorBarContinuous for a full explanation.}

\item{vertical}{A logical value indicating the direction of colorbar if 
parameter 'drawleg' is 'bar'. The default value is TRUE.}

\item{toptitle}{A character string of the top title of the figure, scalable 
with parameter 'title_scale'.}

\item{caption}{A character string of the caption located at left-bottom of the
plot.}

\item{units}{A character string of the data units, which is the title of the 
legend.}

\item{crop_coastlines}{A named numeric vector [lonmin, lonmax, latmin, latmax] 
indicating the region to plot coastlines. Note that the longitude range 
cannot exceed 180 degrees.}

\item{point_size}{A number of the size of the data points if "style = 'point'".
The default is 'auto' and the function tries to find the appropriate size.}

\item{title_scale}{A number of the size of the top title. The default is 16.}

\item{title_size}{Deprecated. Use 'title_scale' instead.}

\item{dot_size}{A number of the size of the dots. The default is 0.5.}

\item{dots_size}{Deprecated. Use 'dot_size' instead.}

\item{dot_symbol}{A number indicating the dot shape recognized by parameter 
'shape' in \code{geom_point()}.}

\item{dots_shape}{Deprecated. Use 'dot_symbol' instead.}

\item{coast_width}{A number indicating the width of the coastlines. Default is
0.3.}

\item{coastlines_width}{Deprecated. Use 'coast_width' instead.}

\item{fileout}{A character string of the path to save the plot. If not 
specified (default), a graphic device will pop up. The extension should be  
accepted by \code{ggsave()}.}

\item{width}{A number of the plot width, in the units specified in parameter
'size_units'. The default is 8.}

\item{height}{A number of the plot height, in the units specified in parameter 
'size_units'. The default is 4.}

\item{size_units}{A character string of the units of the size of the device
(file or window) to plot in. The default is 'in' (inches). See ?ggsave and
?Devices for details of the corresponding device.}

\item{res}{Resolution of the device (file or window) to plot in. The default 
value is 300. See ?ggsave 'dpi' and ?Devices for details of the 
corresponding device.}
}
\value{
A map plot with speficied projection, either in pop-up window or a 
 saved file.
}
\description{
Transform a regular grid longitude-latitude data to a different projection and 
plot the map. The target projection must be a valid CRS string, preferrably be 
EPSG or ESRI code; check \link[sf]{st_crs} for more explanation. This function
is mainly tested for Robinson projection (ESRI:54030), but it can work with 
other projection types in theory.\cr
The map can be plotted by points or polygon. A legend can be plotted as either
a color bar or a discrete ggplot legend. Dots can be drawn on top of the data,
which can be used for significance test. A mask can be added to not plot the 
data specified. A number of options is provided to adjust aesthetics, like 
position, size, colors, etc.
}
\examples{
data <- array(rep(seq(-10, 10, length.out = 181), 360) + rnorm(360),
             dim = c(lat = 181, lon = 360))
dots <- data
dots[which(dots < 4 & dots > -4)] <- 0
dots[which(dots != 0)] <- 1
 VizRobinson(data, lon = 0:359, lat = -90:90, dots = dots,
             brks = seq(-10, 10, length.out = 11), drawleg = FALSE,
             toptitle = 'synthetic example', vertical = FALSE,
             caption = 'Robinson Projection',
             bar_extra_margin = c(0, 1, 0, 1), width = 8, height = 6)

\donttest{
VizRobinson(data, lon = 0:359, lat = -90:90, mask = dots, drawleg = FALSE,
           target_proj = "+proj=moll", brks = seq(-10, 10, length.out = 11),
           color_fun = ClimPalette("purpleorange"), colNA = 'green',
           toptitle = 'synthetic example', caption = 'Mollweide Projection',
           width = 8, height = 6)
 }
}
