% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ergmlhs.R
\name{ergmlhs}
\alias{ergmlhs}
\alias{\%ergmlhs\%}
\alias{\%ergmlhs\%.network}
\alias{\%ergmlhs\%<-}
\alias{\%ergmlhs\%<-.network}
\alias{print.ergm_lhs}
\alias{summary.ergm_lhs}
\alias{print.summary.ergm_lhs}
\title{An API for specifying aspects of an \code{\link{ergm}} model in the
LHS/basis network.}
\usage{
lhs \%ergmlhs\% setting

\method{\%ergmlhs\%}{network}(lhs, setting)

lhs \%ergmlhs\% setting <- value

\method{\%ergmlhs\%}{network}(lhs, setting) <- value

\method{print}{ergm_lhs}(x, ...)

\method{summary}{ergm_lhs}(object, ...)

\method{print}{summary.ergm_lhs}(x, ...)
}
\arguments{
\item{lhs}{a \code{\link[network:network]{network}} intended to serve as LHS of a \code{\link{ergm}}
call.}

\item{setting}{a character string holding a setting's name.}

\item{value}{value with which to overwrite the setting.}
}
\description{
\verb{\%ergmlhs\%} extracts the setting, while assigning to
it sets or updates it.
}
\details{
The settings are stored in a named list in an \code{"ergm"}
network attribute attached to the LHS network. Currently
understood settings include: \describe{

\item{\code{response}}{Edge attribute to be used as the response
variable, constructed from the \verb{response=} argument of \code{\link[=ergm]{ergm()}}.}

\item{\code{constraints}}{Structural constraints of the network:
inherited by the \verb{constraints=} argument of \code{\link[=ergm]{ergm()}},
\code{\link[=simulate.formula]{simulate.formula()}}, etc..}

\item{\code{obs.constraints}}{Structural constraints of the
observation process: inherited by the \verb{obs.constraints=} argument
of \code{\link[=ergm]{ergm()}}, \code{\link[=simulate.formula]{simulate.formula()}}, etc..}

}
}
\section{Functions}{
\itemize{
\item \code{print(ergm_lhs)}: a print method.

\item \code{summary(ergm_lhs)}: helper method for printing summary.

\item \code{print(summary.ergm_lhs)}: helper method for printing summary.

}}
\keyword{internal}
