% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{florentine}
\alias{florentine}
\alias{flobusiness}
\alias{flomarriage}
\title{Florentine Family Marriage and Business Ties Data as a "network" object}
\source{
\insertCite{PaJo94m}{ergm}.
}
\usage{
data(florentine)
}
\description{
This is a data set of marriage and business ties among Renaissance
Florentine families. The data is originally from \insertCite{PaJo94m;textual}{ergm} via
\code{UCINET} and stored as a \code{\link[network:network]{network}} object.
}
\details{
\insertCite{BrPa86c;textual}{ergm}, in their discussion of local role analysis, use
a subset of data on the social relations among Renaissance Florentine
families (person aggregates) collected by John Padgett from historical
documents. The two relations are business ties (\code{flobusiness} -
specifically, recorded financial ties such as loans, credits and joint
partnerships) and marriage alliances (\code{flomarriage}).

As Breiger & Pattison point out, the original data are symmetrically coded.
This is acceptable perhaps for marital ties, but is unfortunate for the
financial ties (which are almost certainly directed). To remedy this, the
financial ties can be recoded as directed relations using some external
measure of power - for instance, a measure of wealth. Both graphs provide
vertex information on (1) \code{wealth} each family's net wealth in 1427 (in
thousands of lira); (2) \code{priorates} the number of priorates (seats on
the civic council) held between 1282- 1344; and (3) \code{totalties} the
total number of business or marriage ties in the total dataset of 116
families (see \insertCite{BrPa86c;nobrackets}{ergm}, p 239).

Substantively, the data include families who were locked in a struggle for
political control of the city of Florence around 1430. Two factions were
dominant in this struggle: one revolved around the infamous Medicis (9), the
other around the powerful Strozzis (15).

\insertNoCite{WaFa94s}{ergm}
}
\references{
\insertAllCited{}
}
\seealso{
flo, network, plot.network, ergm
}
\keyword{datasets}
