% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_indices.R
\name{compute_indices}
\alias{compute_indices}
\title{Compute both RTI and HFTI}
\usage{
compute_indices(
  data,
  remove_duplicates = TRUE,
  buffer_km = 1,
  ref_dist = 3.5,
  divisor = 50,
  data_type = "toy"
)
}
\arguments{
\item{data}{A data frame with columns "species", "longitude", and "latitude".}

\item{remove_duplicates}{Logical. If TRUE, remove exact duplicates of species + coordinates.}

\item{buffer_km}{Numeric. Buffer size in kilometers for removing nearby points.}

\item{ref_dist}{Numeric. Reference distance in kilometers for RTI.}

\item{divisor}{Numeric. Divisor for the human footprint values in HFTI.}

\item{data_type}{Character. Options are "toy" (default) or "full".}
}
\value{
A list containing:
\describe{
\item{RTI}{A data frame with median RTI values per species.}
\item{HFTI}{A data frame with median HFTI values per species.}
\item{indices}{A data frame combining both RTI and HFTI by species.}
\item{processed_data}{The sf object of occurrences with RTI and HFTI values.}
}
}
\description{
This main function processes occurrence data (removing duplicates, filtering close points),
then calculates the Highway Tolerance Index (RTI) and the Human Footprint Tolerance Index (HFTI).
}
\examples{
# Example usage with internal toy data
# Using coordinates that fall within the provided toy dataset (Bahia, Brazil)
sample_data <- data.frame(
   species = c("SpA", "SpA", "SpB", "SpB"),
   longitude = c(-38.40, -38.41, -38.42, -38.43),
   latitude = c(-12.60, -12.61, -12.62, -12.63)
)

result <- compute_indices(
   data = sample_data,
   remove_duplicates = TRUE,
   buffer_km = 1,
   ref_dist = 3.5,
   divisor = 50
)

print(result$RTI)
print(result$HFTI)
print(result$indices)
}
