% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eclipseplot.R
\name{save_eclipseplot}
\alias{save_eclipseplot}
\title{Export the eclipseplot to a file}
\usage{
save_eclipseplot(plot_object, filename, width = 14, height = 9.8, dpi = 72)
}
\arguments{
\item{plot_object}{The ggplot object returned by eclipseplot().}

\item{filename}{Character. The name of the file to save. Must include extension (e.g., "plot.png").}

\item{width}{Width in inches (Default is 14).}

\item{height}{Height in inches (Default is 9.8).}

\item{dpi}{Resolution (Default is 72).}
}
\value{
No return value, called for side effects (saves a file to the specified location).
}
\description{
Export the eclipseplot to a file
}
\examples{
\donttest{
  # Using a temporary directory
  data(sample_brief)
  p <- eclipseplot(sample_brief)
  tmp_file <- file.path(tempdir(), "test_plot.png")
  save_eclipseplot(p, filename = tmp_file)
}
}
