% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-base.R
\name{print.esn}
\alias{print.esn}
\title{Print model specification of the trained ESN model}
\usage{
\method{print}{esn}(x, ...)
}
\arguments{
\item{x}{An object of class \code{esn}. The result of a call to \code{train_esn()}.}

\item{...}{Currently not in use.}
}
\value{
Print specification of the trained ESN model.
}
\description{
Provides a compact overview of the model specification in the 
   format \code{ESN({n_states, alpha, rho}, {n_models, df})}.
}
\examples{
xdata <- as.numeric(AirPassengers)
xmodel <- train_esn(y = xdata)
print(xmodel)

}
\seealso{
Other base functions: 
\code{\link{forecast_esn}()},
\code{\link{is.esn}()},
\code{\link{is.forecast_esn}()},
\code{\link{is.tune_esn}()},
\code{\link{plot.esn}()},
\code{\link{plot.forecast_esn}()},
\code{\link{plot.tune_esn}()},
\code{\link{summary.esn}()},
\code{\link{summary.tune_esn}()},
\code{\link{train_esn}()},
\code{\link{tune_esn}()}
}
\concept{base functions}
