% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echarty.R
\name{ecr.ebars}
\alias{ecr.ebars}
\title{Error bars}
\usage{
ecr.ebars(wt, encode = list(x = 1, y = c(2, 3, 4)), hwidth = 6, ...)
}
\arguments{
\item{wt}{An echarty widget to add error bars to, see \link{ec.init}.}

\item{encode}{Column selection for both axes (x & y) as vectors, see \href{https://echarts.apache.org/en/option.html#series-bar.encode}{encode}}

\item{hwidth}{Half-width of error bar in pixels, default is 6.}

\item{...}{More parameters for \href{https://echarts.apache.org/en/option.html#series-custom.type}{custom serie}}
}
\value{
A widget with error bars added if successful, otherwise the input widget
}
\description{
Custom series to display error-bars for scatter, bar or line series
}
\details{
Command should be called after \emph{ec.init} where main series are set.\cr
\emph{ecr.ebars} are custom series, so \emph{ec.init(load='custom')} is required. \cr
Horizontal and vertical layouts supported, just switch \emph{encode} values \emph{x} and \emph{y} for both for series and ecr.ebars.\cr
Have own default tooltip format showing \emph{value, high & low}.\cr
Grouped bar series are supported.\cr
Non-grouped series could be shown with formatter \emph{riErrBarSimple} instead of \emph{ecr.ebars}. This is limited to vertical only, see example below.\cr
Other limitations:\cr
\verb{     } manually add axis type='category' when needed\cr
\verb{     } error bars cannot have own name when data is grouped\cr
\verb{     } legend select/deselect will not re-position grouped error bars\cr
}
\examples{
library(dplyr)
df <- mtcars |> group_by(cyl,gear) |> summarise(avg.mpg= round(mean(mpg),2)) |>
  mutate(low = round(avg.mpg-cyl*runif(1),2), 
         high= round(avg.mpg+cyl*runif(1),2))
ec.init(df, load= 'custom', series.param= list(type='bar'),
      xAxis= list(type='category'), tooltip= list(show=TRUE)) |>
ecr.ebars(encode= list(y=c('avg.mpg','low','high'), x='gear'))
#ecr.ebars(encode= list(y=c(3,4,5), x=2))  # ok with data indexes

# same but horizontal
ec.init(df, load= 'custom',
  yAxis= list(type='category'), tooltip= list(show=TRUE),
  series.param= list(type='bar', encode= list(x='avg.mpg', y='gear') )) |>
ecr.ebars(encode= list(x=c('avg.mpg','low','high'), y='gear'))

# ----- riErrBarSimple ------
df <- mtcars |> mutate(name= row.names(mtcars), hi= hp-drat*3, lo= hp+wt*3) |> 
  filter(cyl==4) |> select(name,hp,hi,lo)
ec.init(df, load= 'custom', legend= list(show=TRUE)) |>
ec.upd({ series <- append(series, list(
  list(type= 'custom', name= 'error',
    data= ec.data(df |> select(name,hi,lo)),
    renderItem= htmlwidgets::JS('riErrBarSimple')
  )))
})

}
