% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plugins.R
\name{e_lineRange}
\alias{e_lineRange}
\title{Line range chart}
\usage{
e_lineRange(
  e,
  lower,
  upper,
  name = "lineRange",
  legend = TRUE,
  y_index = 0,
  x_index = 0,
  lineStyle = list(opacity = 0.3, color = "#000", width = 1),
  areaStyle = list(opacity = 0.3, color = "#032", width = 1),
  ...
)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}} or
a proxy as returned by \code{\link{echarts4rProxy}}.}

\item{lower, upper}{series of lower and upper borders of the band}

\item{name}{name of the serie.}

\item{legend}{Whether to add serie to legend.}

\item{x_index, y_index}{Indexes of x and y axis.}

\item{lineStyle}{properties of the border lines}

\item{areaStyle}{properties of the area between the lines}

\item{...}{additional options}
}
\description{
Draw a line range area plot.
}
\examples{

df <- iris |>
  dplyr::group_by(Species) |>
  dplyr::summarise(lower = min(Sepal.Length),
                   upper = max(Sepal.Length))
df |>
  e_chart(Species) |>
  e_lineRange(lower = lower, upper = upper)
}
\seealso{
\href{https://github.com/apache/echarts-custom-series/tree/main/custom-series/lineRange}{official documentation}
}
