% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/energy_distance.R
\name{energy_distance}
\alias{energy_distance}
\title{Compute Energy Distance Between Two Groups}
\usage{
energy_distance(formula, data, standardized = TRUE)
}
\arguments{
\item{formula}{A formula specifying the treated and covariates, e.g., `treated ~ cov1 + cov2`. The treated variable must be binary (0=pool, 1=treated)}

\item{data}{A data frame containing the variables specified in the formula.}

\item{standardized}{If TRUE, the standardized energy distance that lies in the range 0 to 1 is returned, the so-called E-coefficient.
If FALSE, non-scaled energy distance is returned that can be >1.}
}
\value{
A numeric value representing the energy distance between the two groups.
}
\description{
Calculates the energy distance between two groups.
}
\details{
Energy distance is a non-parametric measure of distributional difference. It is sensitive to differences
in location, scale, and shape between groups. Before calculation, the covariates are scaled to a mean value of 0 and a standard deviation of 1.
}
\examples{
dat <- data.frame(
 treated = rep(0:1, c(50, 30)),
 age    = c(rnorm(50, 5, 2),   rnorm(30, 5, 1)),
 weight = c(rnorm(50, 11, 2),  rnorm(30, 10, 1)),
 class  = c(rbinom(50, 3, 0.6),   rbinom(30, 3, 0.4))
 )

 energy_distance(treated ~ age + weight + class, data=dat)

}
