
<!-- README.md is generated from README.Rmd. Please edit that file -->

# dynamicpv: Evaluate present values and cost-effectiveness with dynamic pricing and uptake <img src="man/figures/logo.png" align="right" height="139" />

<!-- badges: start -->

[![Lifecycle:
experimental](https://img.shields.io/badge/lifecycle-experimental-orange.svg)](https://lifecycle.r-lib.org/articles/stages.html#experimental)
[![R-CMD-check](https://github.com/MSDLLCpapers/dynamicpv/actions/workflows/R-CMD-check.yaml/badge.svg)](https://github.com/MSDLLCpapers/dynamicpv/actions/workflows/R-CMD-check.yaml)
[![Codecov test
coverage](https://codecov.io/gh/MSDLLCpapers/dynamicpv/graph/badge.svg)](https://app.codecov.io/gh/MSDLLCpapers/dynamicpv)
<!-- badges: end -->

The goal of ‘dynamicpv’ is to provide a simple way to calculate (net)
present values and outputs from health economic models (especially
cost-effectiveness and budget impact) in discrete time that reflect
dynamic pricing and dynamic uptake.

Dynamic pricing is also known as life cycle pricing; dynamic uptake is
also known as multiple or stacked cohorts, or dynamic disease
prevalence. [Shafrin (2024)](https://doi.org/10.1515/fhep-2024-0014)
provides an explanation of dynamic value elements, in the context of
Generalized Cost Effectiveness Analysis, and [Puls
(2024)](https://doi.org/10.1016/j.jval.2024.03.006) reviews challenges
of incorporating such dynamic value elements. This package aims to
reduce those challenges.

Through the
[dynpv()](https://msdllcpapers.github.io/dynamicpv/reference/dynpv.html)
function, the package provides calculations of the present values of
costs, life years, QALYs or other payoffs allowing for dynamic uptake
and dynamic pricing. The starting point is a conventional cohort
cost-effectiveness model, such as one computed using the
[heemod](https://cran.r-project.org/package=heemod) package.

## Installation

The package should shortly be available on
[CRAN](https://cran.r-project.org/web/packages/index.html). Installing
from here is simplest, once available.

``` r
# CRAN installation - when available
install.packages("dynamicpv")
```

You can install the development version of *dynamicpv* from
[GitHub](https://github.com/) as follows.

``` r
# Install devtools package if not already installed
install.packages("devtools")

# Install dynamicpv using pak from MSD repository
pak::pak("MSDLLCpapers/dynamicpv")
```

Note that the above does not install vignettes. Vignettes may be viewed
on the [package website](https://msdllcpapers.github.io/dynamicpv/) or
by instead running the following.

``` r
devtools::install_github("MSDLLCpapers/dynamicpv", build_vignettes=TRUE)
```

You should then load the package, alongside some other packages used
here.

``` r
# Load the dynamicpv package
library(dynamicpv)

# Recommended others
library(dplyr)
library(heemod)
library(ggplot2)
library(tidyr)
```

## How to use

There are four vignettes provided.

1.  The [Mathematical
    Framework](https://msdllcpapers.github.io/dynamicpv/articles/math-framework.html)
    vignette (`vignette("math-framework")`) describes the motivation and
    mathematical framework behind this package.

2.  The [Net Present
    Value](https://msdllcpapers.github.io/dynamicpv/articles/net-present-value.html)
    vignette (`vignette("net-present-value")`) describes how the package
    can be used to derive Net Present Values of simple cashflows with
    dynamic pricing and/or dynamic uptake.

3.  The [Cost-Effectiveness
    Applications](https://msdllcpapers.github.io/dynamicpv/articles/cost-effectiveness-applications.html)
    (`vignette("cost-effectiveness-applications")`) vignette describes
    how, given a static cost-effectiveness model (single cohort, prices
    constant in real terms), Incremental Cost-Effectiveness Ratios may
    be calculated that allow for dynamic pricing and/or dynamic uptake.
    This is illustrated by taking an example three-state partitioned
    survival model of a new intervention for an oncology indication
    compared to standard of care, with stated assumptions for how
    pricing and uptake may be dynamic. Nominal and Real ICERs are
    plotted over time, illustrating the impact of the loss of
    exclusivity points for each intervention.

4.  The [Budget Impact
    Applications](https://msdllcpapers.github.io/dynamicpv/articles/budget-impact-applications.html)
    (`vignette("budget-impact-applications")`) vignette describes how,
    given a static cost-effectiveness model (single cohort, prices
    constant in real terms) and dynamic uptake, a budget impact can be
    readily calculated. The calculations are repeated with the dynamic
    pricing assumptions to illustrate how easily this can be done, and
    examine the differences between a budget impact assessment with and
    without dynamic pricing.
