% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddbs_utils.R
\name{ddbs_glimpse}
\alias{ddbs_glimpse}
\title{Check first rows of the data}
\usage{
ddbs_glimpse(
  conn,
  name,
  crs = NULL,
  crs_column = "crs_duckspatial",
  quiet = FALSE
)
}
\arguments{
\item{conn}{A connection object to a DuckDB database}

\item{name}{A character string of length one specifying the name of the table,
or a character string of length two specifying the schema and table
names.}

\item{crs}{The coordinates reference system of the data. Specify if the data
doesn't have a \code{crs_column}, and you know the CRS.}

\item{crs_column}{a character string of length one specifying the column
storing the CRS (created automatically by \code{\link{ddbs_write_vector}}).
Set to \code{NULL} if absent.}

\item{quiet}{A logical value. If \code{TRUE}, suppresses any informational messages.
Defaults to \code{FALSE}.}
}
\value{
\code{sf} object
}
\description{
Check first rows of the data
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
library(duckspatial)
library(sf)

# create a duckdb database in memory (with spatial extension)
conn <- ddbs_create_conn(dbdir = "memory")

## read data
argentina_sf <- st_read(system.file("spatial/argentina.geojson", package = "duckspatial"))

## store in duckdb
ddbs_write_vector(conn, argentina_sf, "argentina")

ddbs_glimpse(conn, "argentina")
\dontshow{\}) # examplesIf}
}
