% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtms_probs_summary.R
\name{dtms_probs_summary}
\alias{dtms_probs_summary}
\title{Summarize transition probabilities}
\usage{
dtms_probs_summary(
  probs,
  fromvar = "from",
  tovar = "to",
  timevar = "time",
  Pvar = "P",
  digits = 4,
  format = "decimal",
  sep = "_"
)
}
\arguments{
\item{probs}{Object with transition probabilities as created with \code{dtms_transitions}.}

\item{fromvar}{Character (optional), name of variable with starting state in `probs`. Default is `from`.}

\item{tovar}{Character (optional), name of variable with receiving state in `probs`. Default is `to`.}

\item{timevar}{Character (optional), name of variable with time scale in `probs`. Default is `time`.}

\item{Pvar}{Character (optional), name of variable with transition probabilities in `probs`. Default is `P`.}

\item{digits}{Numeric (optional), number of digits to return, default is 6.}

\item{format}{Character (optional), show results in decimal format or percentage, either `decimal` or `percent`. Default is `decimal`.}

\item{sep}{Character (optional), separator between short state name and value of time scale. Default is `_`.}
}
\value{
A data frame
}
\description{
Provides several summary statistics on transition probabilities.
}
\examples{
simple <- dtms(transient=c("A","B"),
               absorbing="X",
               timescale=0:20)
estdata <- dtms_format(data=simpledata,
                       dtms=simple,
                       idvar="id",
                       timevar="time",
                       statevar="state")
estdata <- dtms_clean(data=estdata,
                      dtms=simple)
fit <- dtms_fit(data=estdata)
probs    <- dtms_transitions(dtms=simple,
                             model = fit)
summary(probs)
}
