% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-manipulation.R
\name{embed_into_cartesian}
\alias{embed_into_cartesian}
\title{Embed Data into Cartesian Product Frame}
\usage{
embed_into_cartesian(dt, group_vars, dt_frame = NULL, fill = NA)
}
\arguments{
\item{dt}{A data.table to expand.}

\item{group_vars}{Character vector of column names defining the grouping
structure.}

\item{dt_frame}{Optional data.table containing the target cartesian frame.
If NULL (default), creates cartesian product from unique values in dt.}

\item{fill}{Value to fill for missing combinations. Default is NA.
Set to NA to leave gaps unfilled.}
}
\value{
A data.table with all combinations of group_vars, with original
data merged in.
}
\description{
Expands a data.table to include all combinations of the specified grouping
variables (cartesian product). Missing combinations are filled with NA or
a specified value.
}
\examples{
library(data.table)
dt <- data.table(
  year = c(2020, 2020, 2021),
  region = c("A", "B", "A"),
  value = c(10, 20, 30)
)
embed_into_cartesian(dt, c("year", "region"))

}
