% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_percentile.R
\name{dist_percentile}
\alias{dist_percentile}
\title{Percentile distribution}
\usage{
dist_percentile(x, percentile)
}
\arguments{
\item{x}{A list of values}

\item{percentile}{A list of percentiles}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

The Percentile distribution is a non-parametric distribution defined by
a set of quantiles at specified percentile values. This distribution is
useful for representing empirical distributions or elicited expert
knowledge when only percentile information is available. The distribution
uses linear interpolation between percentiles and can be used to
approximate complex distributions that may not have simple parametric forms.
}
\details{
We recommend reading this documentation on \href{https://pkg.mitchelloharawild.com/distributional/reference/dist_percentile.html}{pkgdown} which renders math nicely.
\url{https://pkg.mitchelloharawild.com/distributional/reference/dist_percentile.html}

In the following, let \eqn{X} be a Percentile random variable defined by
values \eqn{x_1, x_2, \ldots, x_n} at percentiles
\eqn{p_1, p_2, \ldots, p_n} where \eqn{0 \le p_i \le 100}.

\strong{Support}: \eqn{[\min(x_i), \max(x_i)]} if \eqn{\min(p_i) > 0} or
\eqn{\max(p_i) < 100}, otherwise support is approximated from the
specified percentiles.

\strong{Mean}: Approximated numerically using spline interpolation and
numerical integration:

\deqn{
    E(X) \approx \int_0^1 Q(u) du
  }{
    E(X) ≈ integral_0^1 Q(u) du
  }

  where \eqn{Q(u)} is a spline function interpolating the percentile values.

\strong{Variance}: Approximated numerically.

\strong{Probability density function (p.d.f)}: Approximated numerically using
kernel density estimation from generated samples.

\strong{Cumulative distribution function (c.d.f)}: Defined by linear
interpolation:

\deqn{
    F(t) = \begin{cases}
      p_1/100 & \text{if } t < x_1 \\
      p_i/100 + \frac{(t - x_i)(p_{i+1} - p_i)}{100(x_{i+1} - x_i)} & \text{if } x_i \le t < x_{i+1} \\
      p_n/100 & \text{if } t \ge x_n
    \end{cases}
  }{
    F(t) = p_i/100 + (t - x_i)(p_{i+1} - p_i) / (100(x_{i+1} - x_i)) for x_i ≤ t < x_{i+1}
  }

  \strong{Quantile function}: Defined by linear interpolation:

\deqn{
    Q(u) = x_i + \frac{(100u - p_i)(x_{i+1} - x_i)}{p_{i+1} - p_i}
  }{
    Q(u) = x_i + (100u - p_i)(x_{i+1} - x_i) / (p_{i+1} - p_i)
  }

for \eqn{p_i/100 \le u \le p_{i+1}/100}.
}
\examples{
dist <- dist_normal()
percentiles <- seq(0.01, 0.99, by = 0.01)
x <- vapply(percentiles, quantile, double(1L), x = dist)
dist_percentile(list(x), list(percentiles*100))

}
