% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_chisq.R
\name{dist_chisq}
\alias{dist_chisq}
\title{The (non-central) Chi-Squared Distribution}
\usage{
dist_chisq(df, ncp = 0)
}
\arguments{
\item{df}{Degrees of freedom (non-centrality parameter). Can be any
positive real number.}

\item{ncp}{Non-centrality parameter. Can be any non-negative real number.
Defaults to 0 (central chi-squared distribution).}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Chi-square distributions show up often in frequentist settings
as the sampling distribution of test statistics, especially
in maximum likelihood estimation settings.
}
\details{
We recommend reading this documentation on \href{https://pkg.mitchelloharawild.com/distributional/reference/dist_chisq.html}{pkgdown} which renders math nicely.
\url{https://pkg.mitchelloharawild.com/distributional/reference/dist_chisq.html}

In the following, let \eqn{X} be a \eqn{\chi^2} random variable with
\code{df} = \eqn{k} and \code{ncp} = \eqn{\lambda}.

\strong{Support}: \eqn{R^+}, the set of positive real numbers

\strong{Mean}: \eqn{k + \lambda}

\strong{Variance}: \eqn{2(k + 2\lambda)}

\strong{Probability density function (p.d.f)}:

For the central chi-squared distribution (\eqn{\lambda = 0}):

\deqn{
    f(x) = \frac{1}{2^{k/2} \Gamma(k/2)} x^{k/2 - 1} e^{-x/2}
  }{
    f(x) = 1 / (2^(k/2) \Gamma(k/2)) x^(k/2 - 1) exp(-x/2)
  }

For the non-central chi-squared distribution (\eqn{\lambda > 0}):

\deqn{
    f(x) = \frac{1}{2} e^{-(x+\lambda)/2} \left(\frac{x}{\lambda}\right)^{k/4-1/2} I_{k/2-1}\left(\sqrt{\lambda x}\right)
  }{
    f(x) = (1/2) exp(-(x+\lambda)/2) (x/\lambda)^(k/4-1/2) I_(k/2-1)(sqrt(\lambda x))
  }

where \eqn{I_\nu(z)} is the modified Bessel function of the first kind.

\strong{Cumulative distribution function (c.d.f)}:

For the central chi-squared distribution (\eqn{\lambda = 0}):

\deqn{
    F(x) = \frac{\gamma(k/2, x/2)}{\Gamma(k/2)} = P(k/2, x/2)
  }{
    F(x) = \gamma(k/2, x/2) / \Gamma(k/2) = P(k/2, x/2)
  }

where \eqn{\gamma(s, x)} is the lower incomplete gamma function and
\eqn{P(s, x)} is the regularized gamma function.

For the non-central chi-squared distribution (\eqn{\lambda > 0}):

\deqn{
    F(x) = \sum_{j=0}^{\infty} \frac{e^{-\lambda/2} (\lambda/2)^j}{j!} P(k/2 + j, x/2)
  }{
    F(x) = sum_(j=0)^(\infty) exp(-\lambda/2) (\lambda/2)^j / j! P(k/2 + j, x/2)
  }

This is approximated numerically.

\strong{Moment generating function (m.g.f)}:

For the central chi-squared distribution (\eqn{\lambda = 0}):

\deqn{
    E(e^{tX}) = (1 - 2t)^{-k/2}, \quad t < 1/2
  }{
    E(e^(tX)) = (1 - 2t)^(-k/2), t < 1/2
  }

For the non-central chi-squared distribution (\eqn{\lambda > 0}):

\deqn{
    E(e^{tX}) = \frac{e^{\lambda t / (1 - 2t)}}{(1 - 2t)^{k/2}}, \quad t < 1/2
  }{
    E(e^(tX)) = exp(\lambda t / (1 - 2t)) / (1 - 2t)^(k/2), t < 1/2
  }

\strong{Skewness}:

\deqn{
    \gamma_1 = \frac{2^{3/2}(k + 3\lambda)}{(k + 2\lambda)^{3/2}}
  }{
    \gamma_1 = 2^(3/2) (k + 3\lambda) / (k + 2\lambda)^(3/2)
  }

For the central case (\eqn{\lambda = 0}), this simplifies to
\eqn{\sqrt{8/k}}.

\strong{Excess Kurtosis}:

\deqn{
    \gamma_2 = \frac{12(k + 4\lambda)}{(k + 2\lambda)^2}
  }{
    \gamma_2 = 12(k + 4\lambda) / (k + 2\lambda)^2
  }

For the central case (\eqn{\lambda = 0}), this simplifies to
\eqn{12/k}.
}
\examples{
dist <- dist_chisq(df = c(1,2,3,4,6,9))

dist
mean(dist)
variance(dist)
skewness(dist)
kurtosis(dist)

generate(dist, 10)

density(dist, 2)
density(dist, 2, log = TRUE)

cdf(dist, 4)

quantile(dist, 0.7)

}
\seealso{
\link[stats:Chisquare]{stats::Chisquare}
}
