% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_counts.R
\name{derive_counts}
\alias{derive_counts}
\title{Derive Unreported Diagnostic Test Counts}
\usage{
derive_counts(
  n,
  sensitivity = NULL,
  specificity = NULL,
  ppv = NULL,
  npv = NULL,
  prevalence = NULL,
  tol = 1e-06
)
}
\arguments{
\item{n}{Total sample size.}

\item{sensitivity}{Test sensitivity.}

\item{specificity}{Test specificity.}

\item{ppv}{Positive predictive value.}

\item{npv}{Negative predictive value.}

\item{prevalence}{Pretest probability.}

\item{tol}{Numerical tolerance for validation.}
}
\value{
An object of class \code{diagcounts} with elements TP, FN, FP, TN.
}
\description{
Recovers unreported true positive (TP), false negative (FN),
false positive (FP), and true negative (TN) counts using a
system of linear equations.
}
\examples{
# Recover unreported diagnostic counts from published accuracy measures
derive_counts(
n = 105,
sensitivity = 0.6,
specificity = 0.893,
prevalence = 0.733
)

# Recover counts using predictive values
derive_counts(
  n = 160,
  sensitivity = 0.75,
  ppv = 0.75,
  npv = 0.75
)
}
\references{
Xie X, Wang M, Antony J, Vandersluis S, Kabali CB (2025).
System of Linear Equations to Derive Unreported Test Accuracy Counts.
Statistics in Medicine. https://doi.org/10.1002/sim.70336
}
