% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{layer}
\alias{layer}
\title{Internal: wrap a model and its child predictors}
\usage{
layer(pred, model, pred_deps_predict = NULL)
}
\arguments{
\item{pred}{Prediction function for the nuisance node (typically the
\code{predict} component of a nuisance specification).}

\item{model}{Fitted model object returned by the corresponding
\code{fit()}.}

\item{pred_deps_predict}{Optional list of child predictors, each of
which will be called on \code{newdata} and passed into \code{pred}
under the appropriate argument name.}
}
\value{
A function \code{f(newdata, ...)} calling
\code{pred(model, data = newdata, ...)} with extra arguments coming
from \code{pred_deps_predict}. Intended for internal use.
}
\description{
Wraps a fitted model and its prediction function into a layered
predictor that also calls dependency predictors for nuisance inputs.
This is used internally in \code{mode = "predict"} to build
cross-fitted predictors that compose multiple nuisance learners.
}
\keyword{internal}
