% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Backfill-validity.R
\name{v_opening}
\alias{v_opening}
\alias{v_opening_min_dose}
\alias{v_opening_min_cohorts}
\alias{v_opening_min_responses}
\title{Internal Helper Functions for Validation of \code{\link{Opening}} Objects}
\usage{
v_opening_min_dose(object)

v_opening_min_cohorts(object)

v_opening_min_responses(object)
}
\arguments{
\item{object}{(\code{Opening})\cr object to validate.}
}
\value{
A \code{character} vector with the validation failure messages,
or \code{TRUE} in case validation passes.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

These functions are only used internally to validate the format of an input
\code{\link{Opening}} or inherited classes and therefore not exported.
}
\section{Functions}{
\itemize{
\item \code{v_opening_min_dose()}: validates that the \code{\link{OpeningMinDose}} object
contains valid \code{min_dose} slot.

\item \code{v_opening_min_cohorts()}: validates that the \code{\link{OpeningMinCohorts}} object
contains valid \code{min_cohorts} slot.

\item \code{v_opening_min_responses()}: validates that the \code{\link{OpeningMinResponses}} object
contains valid \code{min_responses} and \code{include_lower_doses} slots.

}}
