% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rules-class.R
\docType{class}
\name{IncrementsRelative-class}
\alias{IncrementsRelative-class}
\alias{.IncrementsRelative}
\alias{IncrementsRelative}
\alias{.DefaultIncrementsRelative}
\title{\code{IncrementsRelative}}
\usage{
IncrementsRelative(intervals, increments)

.DefaultIncrementsRelative()
}
\arguments{
\item{intervals}{(\code{numeric})\cr see slot definition.}

\item{increments}{(\code{numeric})\cr see slot definition.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

\code{\link{IncrementsRelative}} is the class for increments control based on relative
differences in intervals.
}
\section{Slots}{

\describe{
\item{\code{intervals}}{(\code{numeric})\cr a vector with the left bounds of the relevant
intervals. For example, \code{intervals  = c(0, 50, 100)} specifies three intervals:
\eqn{(0, 50)}, \eqn{[50, 100)} and \eqn{[100, +Inf)}. That means, the right
bound of the intervals are exclusive to the interval and the last interval
goes from the last value to infinity.}

\item{\code{increments}}{(\code{numeric})\cr a vector of the same length with the maximum
allowable relative increments in the \code{intervals}.}
}}

\note{
Typically, end users will not use the \code{.DefaultIncrementsRelative()} function.
}
\examples{
# This is the example of a rule for:
# maximum doubling the dose if the current dose is <20
# or only maximum increasing the dose by 1.33 if the current dose is >=20.
my_increments <- IncrementsRelative(
  intervals = c(0, 20),
  increments = c(1, 0.33)
)
}
