% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scenario_refi.R
\name{simulate_shock}
\alias{simulate_shock}
\title{Apply scenario shocks to a set of  Discounted Cash Flow (DCF) assumptions}
\usage{
simulate_shock(cfg, deltas = list())
}
\arguments{
\item{cfg}{list. Base assumptions (e.g. those passed to \code{\link[=dcf_calculate]{dcf_calculate()}}).
Fields read if present: \code{disc_rate}, \code{exit_yield}, \code{entry_yield}, \code{capex},
\code{index_rent}, \code{vacancy}.}

\item{deltas}{list. Supported keywords:
\itemize{
\item \code{d_rate} (additive on \code{disc_rate}, decimal),
\item \code{d_exit_yield} (additive on \code{exit_yield}, decimal),
\item \code{d_noi} (multiplicative on \code{entry_yield}, i.e. on year-1 net operating income \code{NOI_y1}),
\item \code{d_capex} (multiplicative on \code{capex}),
\item \code{d_index} (multiplicative on \code{index_rent}),
\item \code{d_vacancy} (multiplicative on \code{vacancy}).
}}
}
\value{
list \code{cfg_choc} with the same structure as \code{cfg}.
}
\description{
Applies additive shifts (rates and yields in decimal form) or proportional
scalings (NOI, CAPEX) to a list of parameters. Preserves field names.
}
