% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_system_boundaries.R
\name{set_system_boundaries}
\alias{set_system_boundaries}
\title{Define system boundaries for carbon footprint calculation}
\usage{
set_system_boundaries(scope = "farm_gate", include = NULL)
}
\arguments{
\item{scope}{Character. Options:
\itemize{
\item "farm_gate" (default): includes enteric, manure, soil, energy, inputs
\item "cradle_to_farm_gate": includes feed production + farm emissions
\item "partial": user-specified
}}

\item{include}{Character vector of processes to include (optional).}
}
\value{
A list with $scope and $include
}
\description{
Define system boundaries for carbon footprint calculation
}
\examples{
b1 <- set_system_boundaries("farm_gate")
b2 <- set_system_boundaries(include = c("enteric", "manure", "soil"))
b3 <- set_system_boundaries(include = c("enteric", "manure"))
b1$scope
b2$include
b3$include
}
