% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_emissions_enteric.R
\name{calc_emissions_enteric}
\alias{calc_emissions_enteric}
\title{Calculate enteric methane emissions}
\usage{
calc_emissions_enteric(
  n_animals,
  cattle_category = "dairy_cows",
  production_system = "mixed",
  avg_milk_yield = 6000,
  avg_body_weight = NULL,
  dry_matter_intake = NULL,
  feed_inputs = NULL,
  ym_percent = 6.5,
  emission_factor_ch4 = NULL,
  tier = 1L,
  gwp_ch4 = 27.2,
  boundaries = NULL
)
}
\arguments{
\item{n_animals}{Numeric scalar > 0. Number of animals.}

\item{cattle_category}{Character. One of "dairy_cows", "heifers", "calves", "bulls".
Default = "dairy_cows".}

\item{production_system}{Character. One of "intensive", "extensive", "mixed".
Default = "mixed".}

\item{avg_milk_yield}{Numeric >= 0. Average annual milk yield per cow (kg/year).
Default = 6000. Used in Tier 2 fallback for dairy cows.}

\item{avg_body_weight}{Numeric > 0. Average live weight (kg). If NULL, a
category-specific default is used (e.g. 550 kg for dairy cows).}

\item{dry_matter_intake}{Numeric > 0. Dry matter intake (kg/animal/day).
If provided (Tier 2), overrides body-weight/energy-based estimation.}

\item{feed_inputs}{Named numeric vector/list with feed DM amounts in kg/year
per herd (e.g., grain_dry, grain_wet, byproducts, proteins). Optional.
If given and \code{dry_matter_intake} is NULL, DMI is inferred as
\code{sum(feed_inputs)/(n_animals*365)}.}

\item{ym_percent}{Numeric in (0, 100]. Methane conversion factor Ym (\% of GE to CH4).
Default = 6.5.}

\item{emission_factor_ch4}{Numeric > 0. If provided, CH4 EF (kg CH4/head/year)
is used directly; otherwise it is calculated (Tier 1 or Tier 2).}

\item{tier}{Integer 1 or 2. Default = 1.}

\item{gwp_ch4}{Numeric. GWP for CH4 (100-yr, AR6). Default = 27.2.}

\item{boundaries}{Optional list from \code{set_system_boundaries()}.}
}
\value{
A list with annual CH4 emissions and annual CO2-equivalent emissions.
\itemize{
\item \code{ch4_kg}: annual CH4 emissions (kg CH4 yr-1)
\item \code{co2eq_kg}: annual CO2-equivalent emissions (kg CO2eq yr-1), for compatibility
with \code{calc_total_emissions()}
\item \code{units_ch4} and \code{units_co2eq}: explicit unit strings
}
}
\description{
Estimates enteric methane (CH4) emissions from cattle using IPCC Tier 1 or
Tier 2 approaches with practical defaults for dairy systems.
}
\examples{
\donttest{
# Tier 1, mixed dairy cows
calc_emissions_enteric(n_animals = 100)

# Tier 2 with explicit DMI
calc_emissions_enteric(
  n_animals = 120, tier = 2, avg_milk_yield = 7500, dry_matter_intake = 18
)

# Boundary exclusion: enteric not included
b <- list(include = c("manure", "energy"))
calc_emissions_enteric(100, boundaries = b)$co2eq_kg # NULL → excluded
}
}
